.cseg
; ***********************************************************************************************
;	Initialisierung:			(c) 2024 by DC7GB unter: BY-NC-SA 4.0
; ***********************************************************************************************


; -----------------------------------------------------------------------------------------------
; LED sehr schnell blinken lassen:
; -----------------------------------------------------------------------------------------------

LEDVERYFAST:	sbrs	tics,BIT2		; Timer abgelaufen?
		cbi	PORTA,LED		; LED aus
		sbrc	tics,BIT2		; Timer abgelaufen?
		sbi	PORTA,LED		; LED ein
; -------------
		ret


; -----------------------------------------------------------------------------------------------
; LED schnell blinken lassen:
; -----------------------------------------------------------------------------------------------

LEDFAST:	sbrs	tics,BIT4		; Timer abgelaufen?
		cbi	PORTA,LED		; LED aus
		sbrc	tics,BIT4		; Timer abgelaufen?
		sbi	PORTA,LED		; LED ein
; -------------
		ret



; -----------------------------------------------------------------------------------------------
; LED langsam blinken lassen:
; -----------------------------------------------------------------------------------------------

LEDSLOW:	sbrs	tics,BIT7		; Timer abgelaufen?
		cbi	PORTA,LED		; LED aus
		sbrc	tics,BIT7		; Timer abgelaufen?
		sbi	PORTA,LED		; LED ein
; -------------
		ret



; -----------------------------------------------------------------------------------------------
; Exklusiv 50µs/100µs bei 16 MHz warten:
; -----------------------------------------------------------------------------------------------

WAIT100US:	rcall	wait50us
WAIT50US:	push	akku0
		push	temp
; -------------
		ldi	temp,196
		mov	akku0,temp
W10MS_LOOP:	nop
		dec	akku0
		brne	w10ms_loop
; -------------
		pop	temp
		pop	akku0
		ret
		ret


; -----------------------------------------------------------------------------------------------
; Lese Byte aus EEPROM von Adresse (Y)
; -----------------------------------------------------------------------------------------------

EEREAD:		sbic	EECR,EEPE		; EEPROM ready?
		rjmp	eeread			; nein, warte...
		out	EEARH,YH		; setze die EEPROM-
		out	EEARL,YL		; ...Leseadresse
		sbi	EECR,EERE		; EEPROM lesen
		in	temp,EEDR		; Datenbyte übergeben
; EE-Parken:
		push	temp
		clr	temp			; setze
		out	EEARH,temp		; ...die EEPROM-
		out	EEARL,temp		; ...Parkadresse auf 0
		pop	temp
; --------------
		ret



; -----------------------------------------------------------------------------------------------
; erzeuge ein Rechtecksignal						(ca. 750 kHz @ 16 MHz)
; -----------------------------------------------------------------------------------------------

TEST_OSZ:	rcall	test_toggle
		rjmp	test_osz



; -----------------------------------------------------------------------------------------------
; TEST-Pin an Port-B löschen:
; -----------------------------------------------------------------------------------------------

TEST_CLR:	cbi	PORTB,TEST
; -------------
		ret



; -----------------------------------------------------------------------------------------------
; TEST-Pin an Port-B setzen:
; -----------------------------------------------------------------------------------------------

TEST_SET:	sbi	PORTB,TEST
; -------------
		ret



; -----------------------------------------------------------------------------------------------
; LHL-Puls an TEST-Pin Port-B ausgeben:
; -----------------------------------------------------------------------------------------------

TEST_PULS:	cbi	PORTB,TEST
		sbi	PORTB,TEST
		cbi	PORTB,TEST
; -------------
		ret



; -----------------------------------------------------------------------------------------------
; TEST-Pin an PORTB wechseln:
; -----------------------------------------------------------------------------------------------

TEST_TOGGLE:	sbi	PINB,TEST
; -------------
		ret



; --------------------------------------------------------------
; Byte in <temp> an PORTB ausgeben	         (135 Zyklen)
; --------------------------------------------------------------

TEST_OUT:	push	temp			; Variable nicht ändern!
		push	buffer			; buffer wird gebraucht
; -------------
		ldi	buffer,8		; ...als Bitzähler
PORTSHIFT:	rol	temp			; MSB nach CY bringen, 0?
		brcc	portaus			; ja...
		nop				; Zeitausgleich für bcc
		sbi	PORTB,TEST		; (2) Bitstart
		cbi	PORTB,TEST		; (2) ...markieren
		sbi	PORTB,TEST		; (2) 1-Bit ausgeben
		rjmp	portend			; (2)

PORTAUS:	sbi	PORTB,TEST		; (2) Bitstart
		cbi	PORTB,TEST		; (2) ...markieren
		cbi	PORTB,TEST		; (2) 0-Bit ausgeben
		cbi	PORTB,TEST		; (2) Ausgleich für rjmp
PORTEND:	dec	buffer			; alle Bits ausgegeben?
		brne	portshift		; nein...
		nop				; (1) Zeitausgleich
		nop				; (1) ...für das
		nop				; (1) ...letzte
		nop				; (1) ...Bitende
		sbi	PORTB,TEST		; (2) Bitende
		cbi	PORTB,TEST		; (2) ...markieren
; -------------
		pop	buffer			; buffer restaurieren
		pop	temp			; Variable zurück laden!
